#include "player.h"
static str _anim_name [PlayerTypes]={NULL, NULL, "bumblebee", "pyramidtree", "opossum", "woodpecker", "beaver", "racoon", "skunk", "fox", "villain", "fireballpf", "rootspell", "birddropping", "aardvark", "anteater", "star", "iciclepf",};
static LandSpriteType * player_anim [PlayerTypes] [3];
static float _accel(Player * p, float accel, float max_speed);
void player_transfer(Player * self, Player * from_old) {
    self->lifes = from_old->lifes;
    self->variant = from_old->variant;
}
Player* player_make(PlayerType pt, float x, float y) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (! gc->players) {
        gc->players = land_array_new();
    }
    Player * p = NULL;
    if (gc->removed_players) {
        p = land_array_pop(gc->removed_players);
        if (p) {
            land_zero(p, sizeof (* p));
        }
    }
    if (p == NULL) {
        land_alloc(p);
        land_array_add(gc->players, p);
    }
    p->pt = pt;
    if (pt == PlayerWitch) {
        game->current->player = p;
        player_anim [PlayerWitch] [0] = get_animation_type("witch", 1 /* is_player */);
        player_anim [PlayerWitch] [1] = get_animation_type("witch_hat", 1 /* is_player */);
        player_anim [PlayerWitch] [2] = get_animation_type("witch_crown", 1 /* is_player */);
    }
    else {
        player_anim [pt] [0] = get_animation_type(_anim_name [pt], 1 /* is_player */);
    }
    if (pt == PlayerVillain) {
        p->anim = StandingLeft;
    }
    land_sprite_initialize(& p->super.super, player_anim [pt] [0]);
    player_place(p, x, y);
    return p;
}
void player_remove(Player * p) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (! gc->removed_players) {
        gc->removed_players = land_array_new();
    }
    p->removed = 1;
    land_sprite_remove_from_grid(& p->super.super, gc->sprites_grid);
    land_array_add(gc->removed_players, p);
}
void player_place(Player * self, float x, float y) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (self->placed) {
        land_sprite_remove_from_grid(& self->super.super, gc->sprites_grid);
    }
    self->x = x;
    self->y = y;
    land_sprite_place_into_grid(& self->super.super, gc->sprites_grid, x, y);
    self->placed = 1;
}
void player_unplace(Player * self) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (! self->placed) {
        return ;
    }
    self->placed = 0;
    land_sprite_remove_from_grid(& self->super.super, gc->sprites_grid);
}
void player_look(Player * self, int dx) {
    if (dx < 0) {
        self->left = 1;
    }
    if (dx > 0) {
        self->left = 0;
    }
}
void player_draw(LandSprite * self, LandView * view, LandGrid * grid) {
    Player * p = (Player *) self;
    LandAnimation * anim = ((LandSpriteTypeAnimation *) player_anim [p->pt] [p->variant])->animation;
    int f, flip;
    get_animation_frame(p, & f, & flip);
    land_push_transform();
    land_translate(p->x - view->scroll_x, p->y - view->scroll_y);
    float offset = 32;
    land_translate(0, - offset);
    land_rotate(self->angle);
    land_translate(0, offset);
    land_animation_draw_scaled_rotated_tinted_flipped(anim, 0, 0, .5, .5, 0, 1, 1, 1, 1, flip, f);
    land_pop_transform();
    if (grid->debug_bounds) {
        land_color(1, 0, 0, 1);
        float x = p->x - view->scroll_x - self->type->x;
        float y = p->y - view->scroll_y - self->type->y;
        land_rectangle(x, y, x + self->type->w, y + self->type->h);
    }
}
bool player_have_animation_frame(Player * p, int frame) {
    LandAnimation * anim = ((LandSpriteTypeAnimation *) player_anim [p->pt] [p->variant])->animation;
    return land_animation_get_frame(anim, frame) != NULL;
}
Player* make_projectile(int what, Player * p, int x, int y, int dx, int dy) {
    Player * projectile = player_make(what, p->x + x, p->y + y);
    projectile->dx = dx;
    projectile->dy = dy;
    return projectile;
}
void player_tick(Player * p) {
    Game * game = game_global();
    if (p->pt == PlayerWitch) {
        player_move_by_input(p, game->input_kx, game->input_ky);
    }
    else if (p->pt == PlayerVillain) {
        player_move_by_input(p, game->input2_kx, game->input2_ky);
    }
    else if (p->pt == PlayerBumblebee) {
        player_fly_horizontal(p, 3);
    }
    else if (p->pt == PlayerWoodPecker) {
        player_fly_horizontal(p, 4);
    }
    else if (p->pt == PlayerPyramidtree) {
        player_walk_horizontal(p, 1);
    }
    else if (p->pt == PlayerOpossum) {
        player_walk_horizontal(p, 2);
    }
    else if (p->pt == PlayerBeaver) {
        player_move_by_input(p, game->input2_kx, game->input2_ky);
    }
    else if (p->pt == PlayerRacoon) {
        player_move_by_input(p, game->input2_kx, game->input2_ky);
    }
    else if (p->pt == PlayerSkunk) {
        player_walk_horizontal(p, 3);
    }
    else if (p->pt == PlayerAardvark) {
        player_walk_horizontal(p, 1.5);
    }
    else if (p->pt == PlayerAnteater) {
        player_walk_horizontal(p, 2.5);
    }
    else if (p->pt == PlayerFox) {
        player_move_by_input(p, game->input2_kx, game->input2_ky);
    }
    else if (p->pt == PlayerFireball || p->pt == PlayerRootspell || p->pt == PlayerBirdDropping || p->pt == PlayerStar || p->pt == PlayerIcicle) {
        player_move_projectile(p);
    }
}
static float _accel(Player * p, float accel, float max_speed) {
    if (p->pause_counter) {
        p->pause_counter -= 1;
        return p->x;
    }
    if (p->left) {
        p->dx -= accel;
        if (p->dx < - max_speed) {
            p->dx = - max_speed;
        }
    }
    else {
        p->dx += accel;
        if (p->dx > max_speed) {
            p->dx = max_speed;
        }
    }
    return p->x + p->dx;
}
void player_move_by_input(Player * p, int kx, int ky) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (game->door) {
        return ;
    }
    int w = land_grid_width(gc->tiles_grid);
    float nx = p->x, ny = p->y;
    bool jump = 0;
    int attack = 0;
    if (ky == - 1) {
        if (p->variant == 1) {
            attack = 1;
        }
        else {
            jump = 1;
        }
    }
    if (p->pt == PlayerWitch) {
        if (ky == 2) {
            // set by script
            attack = 2;
        }
        if (ky == 1) {
            game->ky_ticks += 1;
            if (p->variant == 0 || p->variant == 2 || game->ky_ticks > 15) {
                if (game->alive > 30 && game->dead == 0) {
                    game->feign_dead = 1;
                }
            }
        }
        else if (game->ky_ticks) {
            if (p->variant == 1) {
                if (game->ky_ticks <= 15) {
                    attack = 2;
                }
            }
            game->ky_ticks = 0;
        }
    }
    if (p->pt == PlayerVillain) {
        if (ky == - 1) {
            if (p->dead) {
                p->dead = 0;
                for (int a = 0; a < 7; a += 1) {
                    float dx = cos(a * pi / 6) * 4;
                    float dy = - sin(a * pi / 6) * 4;
                    make_projectile(PlayerStar, p, 0 /* x */,  /* y */- 64, dx, dy);
                }
                play(StarsAudio, 1, 0, 1);
            }
        }
        if (ky == 1) {
            attack = 1;
        }
    }
    if (p->dead) {
        kx = 0;
        jump = 0;
    }
    if (attack) {
        if (! p->attacking) {
            p->attack2 = attack == 2;
            p->attacking = 1;
        }
    }
    if (jump) {
        if (p->ground) {
            if (p->variant == 0) {
                p->dy = - 5;
            }
            else if (p->variant == 2) {
                p->dy = - 8;
                play(JumpAudio, 1, 0, 1);
            }
        }
    }
    else {
        if (p->dy < 0) {
            p->dy *= 0.88;
        }
    }
    if (p->attacking) {
        p->attacking += 1;
        int aframe = 15;
        if (p->variant == 0) {
            aframe = 14;
        }
        if (p->attacking == aframe) {
            int ay = 32 * 2 + 17;
            int what = PlayerFireball;
            if (p->pt == PlayerVillain) {
                what = PlayerIcicle;
                ay = 32 * 2;
            }
            if (p->attack2) {
                what = PlayerRootspell;
                ay = 32 + 18;
            }
            if (what == PlayerFireball) {
                play(FireballAudio, 1, 0, 1);
            }
            else if (what == PlayerIcicle) {
                play(IcicleAudio, 1, 0, 1);
            }
            else if (what == PlayerRootspell) {
                play(RootspellAudio, 1, 0, 1);
            }
            Player * projectile = player_make(what, p->x + 7, p->y - ay);
            projectile->origin = p->pt;
            projectile->dx = p->left > 0 ? - 7 : 7;
            if (p->attack2) {
                projectile->dy = 1;
            }
            if (what == PlayerFireball) {
                projectile->dy = 2;
            }
            projectile->anim = p->left ? WalkingLeft : WalkingRight;
        }
        if (p->attacking == 20) {
            p->attacking = 0;
        }
        kx = 0;
    }
    if (kx) {
        if (p->ground) {
            p->dx += kx * 0.2;
        }
        else {
            p->dx += kx * 0.1;
        }
        p->left = kx < 0;
    }
    else {
        p->dx *= 0.9;
    }
    bool was_up = p->dy < 0;
    p->dy += 0.3;
    if (was_up && p->dy > 0) {
        float sp = fabs(p->dx);
        if (sp > 3.9 && p->variant == 2) {
            float sx = p->dx * 10;
            if (! land_sprites_grid_get_rectangle_exact_into_list(gc->tiles_grid, p->x - 4 + sx, p->y + 8, p->x + 4 + sx, p->y + 80, NULL)) {
                game->somersault = 1;
            }
        }
    }
    if (p->ground) {
        p->dx *= 0.96;
    }
    else {
        p->dx *= 0.98;
    }
    p->dy *= 0.98;
    if (fabs(p->dx) < 0.01) {
        p->dx = 0;
    }
    if (p->dx < - 4) {
        p->dx = - 4;
    }
    if (p->dx > 4) {
        p->dx = 4;
    }
    ny += p->dy;
    if (ny >= land_grid_height(gc->tiles_grid)) {
        ny = land_grid_height(gc->tiles_grid) - 1;
        if (! p->dead) {
            if (p->pt == PlayerBeaver) {
                player_remove(p);
                return ;
            }
            else {
                p->dead = 1;
                play(FallAudio, 1, 0, 1);
                p->lifes -= 1;
            }
        }
    }
    p->out_door += 1;
    if (p->dy > 0) {
        float lx = 0, rx = 0;
        if (p->left) {
            lx = 7 - p->dx;
        }
        else {
            rx = 7 + p->dx;
        }
        LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->tiles_grid, nx - 4 - lx, ny - p->dy - 2, nx + 4 + rx, ny);
        if (colliders) {
            bool surface = 0;
            float top = ny;
            {
                LandListIterator __iter0__ = LandListIterator_first(colliders);
                for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                    if (c->sid == Door) {
                        if (p->pt == PlayerWitch && gc->gem_count == 0) {
                            if (! game->door) {
                                if (p->out_door > 30) {
                                    play(DoorAudio, 1, 0, 1);
                                    game->door = c;
                                    game->door_frame = 0;
                                    if (p->x < w / 2) {
                                        game->load_next_level = - 1;
                                    }
                                    else {
                                        game->load_next_level = 1;
                                    }
                                }
                                p->out_door = 0;
                            }
                        }
                        continue;
                    }
                    if (c->sid >= GemDeep01 && c->sid <= GemHigh12) {
                        continue;
                    }
                    if (c->y <= top) {
                        top = c->y;
                        surface = 1;
                    }
                }
            }
            land_list_destroy(colliders);
            ny = top;
            if (surface) {
                if (! p->ground) {
/*
                     landing after a jump slows slightly, this way
                     we get a nice continuous hop when keeping
                     jump and run pressed
*/
                    p->dx *= 0.45 /* comes to about 4 tiles per jump */;
                }
                p->ground = 1;
                p->dy = 0;
            }
            else {
                p->ground = 0;
            }
        }
        else {
            p->ground = 0;
        }
    }
    else {
        p->ground = 0;
    }
    nx += p->dx;
    // confine to level
    if (nx < 0) {
        nx = 0;
    }
    if (nx > w) {
        nx = w;
    }
    player_place(p, nx, ny);
    if (! p->dead) {
        LandRectangle cr = land_sprite_rect(& p->super.super);
        // horizontal tile collisions
        LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->tiles_grid, cr.x, cr.y, cr.x + cr.w, cr.y + cr.h);
        if (colliders) {
            {
                LandListIterator __iter0__ = LandListIterator_first(colliders);
                for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                    if (c->sid >= GemDeep01 && c->sid <= GemHigh12) {
                        if (p->y - c->y < 68) {
                            land_sprite_remove_from_grid(c, gc->tiles_grid);
                            int i = c->sid - GemDeep01;
                            gc->gem_count -= 1;
/*
                             0  1  2  3  4  5  6  7  8  9  10 11 12
                             C  C# D  D# E  F  F# G  G# A  Bb B  C
                             Ru Op Be Ca Ci Em Op Aq Op Sa Ca Am Di
*/
                            play(Ding1Audio + i, 1, 0, 1);
                            int gv = gemtable [i];
                            gc->gems [gv] -= 1;
                        }
                        continue;
                    }
                    if (c->sid == Heart) {
                        if (p->y - c->y < 68) {
                            land_sprite_remove_from_grid(c, gc->tiles_grid);
                            p->lifes += 1;
                            play(HeartAudio, 1, 0, 1);
                        }
                        continue;
                    }
                }
            }
            land_list_destroy(colliders);
        }
        colliders = land_sprites_grid_get_rectangle_exact(gc->sprites_grid, cr.x, cr.y, cr.x + cr.w, cr.y + cr.h);
        if (colliders) {
            bool collided = 0;
            {
                LandListIterator __iter0__ = LandListIterator_first(colliders);
                for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                    if (c == (& p->super.super)) {
                        continue;
                    }
/*
                     Note: sprites_grid must only contain Player objects
                    LandRectangle cr2 = land_sprite_rect(c)
*/
                    Player * op = (Player *) c;
                    if (op->origin == p->pt) {
                        continue;
                    }
                    if (op->pt == PlayerStar) {
                        continue;
                    }
                    if (op->pt == PlayerBirdDropping) {
                        player_remove(op);
                    }
                    if (op->pt == PlayerRootspell) {
                        op->dx = 0;
                        op->dy = 1;
                    }
                    if (op->pt == PlayerWitch) {
                        continue;
                    }
                    if (op->pt == PlayerBeaver) {
                        if (! op->once) {
                            op->once = 1;
                            script_beaver();
                        }
                        continue;
                    }
                    if (op->pt == PlayerRacoon) {
                        if (! op->once) {
                            op->once = 1;
                            script_racoon();
                        }
                        continue;
                    }
                    if (op->pt == PlayerFox) {
                        continue;
                    }
                    if (! op->attacking) {
                        collided = 1;
                        op->attacking += 60;
                    }
                }
            }
            land_list_destroy(colliders);
            if (collided) {
                play(BiteAudio, 1, 0, 1);
                p->dead = 1;
                p->lifes -= 1;
            }
        }
    }
    if (fabs(p->dx) > 0.1 || fabs(p->dy) > 0.1) {
        game->trail_x [game->trail] = nx;
        game->trail_y [game->trail] = ny;
        game->trail += 1;
        if (game->trail == 300) {
            game->trail = 0;
        }
        if (game->trail0 == game->trail) {
            game->trail0 += 1;
            if (game->trail0 == 300) {
                game->trail0 = 0;
            }
        }
    }
    if (p->dead) {
        set_wanted_animation(p, DyingRight, kx);
    }
    else if (p->attacking) {
        set_wanted_animation(p, AttackingRight, kx);
    }
    else if (! p->ground) {
        set_wanted_animation(p, JumpingRight, kx);
    }
    else if (kx) {
        set_wanted_animation(p, WalkingRight, kx);
    }
    else if (game->idle > 60 * 7) {
        set_wanted_animation(p, SittingRight, 0);
    }
    else {
        set_wanted_animation(p, StandingRight, 0);
    }
}
void player_move_projectile(Player * p) {
    if (p->dead) {
        return ;
    }
    if (p->recharging) {
        if (p->anim_t < 4 * 5 - 1) {
            p->anim_t += 1;
        }
        p->recharging -= 1;
        if (p->recharging == 0) {
            player_remove(p);
        }
        return ;
    }
    Game * game = game_global();
    Persist * gc = game->current;
    int w = land_grid_width(gc->tiles_grid);
    int h = land_grid_height(gc->tiles_grid);
    float nx = p->x + p->dx;
    float ny = p->y + p->dy;
    bool die = 0;
    int cy = - 2;
    if (p->pt == PlayerFireball) {
        cy = 8;
    }
    LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->tiles_grid, nx - 8, ny - 8, nx + 8, ny + cy);
    if (colliders) {
        {
            LandListIterator __iter0__ = LandListIterator_first(colliders);
            for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                if (c->sid >= GemDeep01 && c->sid <= GemHigh12) {
                    continue;
                }
                if (c->sid == Heart) {
                    continue;
                }
                die = 1;
            }
        }
        land_list_destroy(colliders);
    }
    if (nx > w || ny > h || nx < 0 || ny < 0) {
        die = 1;
    }
    if (die) {
        if (p->pt == PlayerFireball || p->pt == PlayerIcicle || p->pt == PlayerStar) {
            player_remove(p);
        }
        else if (p->pt == PlayerBirdDropping) {
            play(DroppingAudio, 1, 0, 1);
            p->recharging = 5 * 60;
        }
        else if (p->pt == PlayerRootspell) {
            p->recharging = 2 * 60;
        }
    }
    else {
        player_place(p, nx, ny);
        set_wanted_animation(p, WalkingRight, p->dx);
        if (p->pt == PlayerRootspell || p->pt == PlayerBirdDropping) {
            p->anim_t = 0;
        }
    }
}
void player_fly_horizontal(Player * p, float speed) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (! p->attacking) {
        int w = land_grid_width(gc->tiles_grid);
        float nx = _accel(p, 0.1, speed);
        float ny = p->y + p->dy;
        LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->tiles_grid, nx - 8, ny - TS / 2 - 4, nx + 8, ny - TS / 2 + 4);
        if (colliders) {
            land_list_destroy(colliders);
            p->left = ! p->left;
            nx = p->x;
            p->dx = 0;
            p->pause_counter = 10;
        }
        if (nx > w) {
            nx = p->x;
            p->left = 1;
            p->dx = 0;
        }
        if (nx < 0) {
            nx = p->x;
            p->left = 0;
            p->dx = 0;
        }
        player_place(p, nx, ny);
        if (p->pt == PlayerWoodPecker) {
            player_check_below(p);
        }
    }
    int kx = p->left ? - 1 : 1;
    if (p->attacking) {
        set_wanted_animation(p, AttackingRight, kx);
        p->attacking -= 1;
    }
    else {
        set_wanted_animation(p, WalkingRight, kx);
    }
}
void player_check_below(Player * p) {
    if (p->recharging) {
        p->recharging -= 1;
        return ;
    }
    Game * game = game_global();
    Persist * gc = game->current;
    LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->sprites_grid, p->x - 8, p->y + 32, p->x + 8, p->x + 400);
    if (colliders) {
        bool collided = 0;
        {
            LandListIterator __iter0__ = LandListIterator_first(colliders);
            for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                Player * cp = (Player *) c;
                if (cp->pt == PlayerWitch && ! cp->dead) {
                    collided = 1;
                    break;
                }
            }
        }
        land_list_destroy(colliders);
        if (collided) {
            play(PoopAudio, 1, 0, 1);
            Player * projectile = player_make(PlayerBirdDropping, p->x + land_rand(- 10, 10), p->y + 16);
            projectile->dy = 3;
            p->recharging = 60;
        }
    }
}
void player_walk_horizontal(Player * p, float speed) {
    Game * game = game_global();
    Persist * gc = game->current;
    if (p->bound) {
        p->bound -= 1;
        return ;
    }
    if (! p->attacking) {
        float nx = _accel(p, 0.1, speed);
        float ny = p->y + p->dy;
        LandList * colliders = land_sprites_grid_get_rectangle_exact(gc->tiles_grid, nx - 8, ny - TS - 4, nx + 8, ny + 4);
        bool hit_head = 0;
        bool have_ground = 0;
        if (colliders) {
            {
                LandListIterator __iter0__ = LandListIterator_first(colliders);
                for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                    if (c->y < p->y) {
                        hit_head = 1;
                    }
                    else {
                        have_ground = 1;
                    }
                }
            }
            land_list_destroy(colliders);
        }
        if (hit_head || ! have_ground) {
            p->dx = 0;
            p->left = ! p->left;
            nx = p->x;
            ny = p->y;
            p->pause_counter = 10;
        }
        LandRectangle cr = land_sprite_rect(& p->super.super);
        colliders = land_sprites_grid_get_rectangle_exact(gc->sprites_grid, cr.x, cr.y, cr.x + cr.w, cr.y + cr.h);
        if (colliders) {
            {
                LandListIterator __iter0__ = LandListIterator_first(colliders);
                for (LandSprite * c = LandListIterator_item(colliders, &__iter0__); LandListIterator_next(colliders, &__iter0__); c = LandListIterator_item(colliders, &__iter0__)) {
                    if (c == (& p->super.super)) {
                        continue;
                    }
                    Player * op = (Player *) c;
                    if (op->pt == PlayerRootspell) {
                        p->bound = 10;
                    }
                    if (op->pt == PlayerFireball) {
                        player_remove(p);
                        return ;
                    }
                }
            }
        }
        player_place(p, nx, ny);
    }
    int kx = p->dx < 0 ? - 1 : 1;
    if (p->attacking) {
        set_wanted_animation(p, AttackingRight, kx);
        p->attacking -= 1;
    }
    else {
        set_wanted_animation(p, WalkingRight, kx);
    }
}
Player* player_find(PlayerType pt) {
    Game * game = game_global();
    Persist * gc = game->current;
    {
        LandArrayIterator __iter0__ = LandArrayIterator_first(gc->players);
        for (Player * a = LandArrayIterator_item(gc->players, &__iter0__); LandArrayIterator_next(gc->players, &__iter0__); a = LandArrayIterator_item(gc->players, &__iter0__)) {
            if (a->pt == pt) {
                return a;
            }
        }
    }
    return NULL;
}
void player_flip(Player * p) {
    p->left = ! p->left;
    p->dx = - p->dx;
}
void player_cancel_texts(void) {
    Game * game = game_global();
    Persist * gc = game->current;
    LandView * view = game->view;
    LandList * visible = land_sprites_grid_get_rectangle_exact(gc->sprites_grid, view->scroll_x, view->scroll_y, view->scroll_x + 800, view->scroll_y + 450);
    {
        LandListIterator __iter0__ = LandListIterator_first(visible);
        for (Player * pl = LandListIterator_item(visible, &__iter0__); LandListIterator_next(visible, &__iter0__); pl = LandListIterator_item(visible, &__iter0__)) {
            if (pl->text) {
                land_free(pl->text);
                pl->text = NULL;
            }
        }
    }
    land_list_destroy(visible);
}
